#pragma once

#include "vector2.h"

class GameObject
{
public:
	virtual void init(Vector2 position, float radius, int color) = 0;
	virtual void draw(void* hdc) = 0;
	virtual void update(float secondsPassed) = 0;
	virtual bool collidesWith(GameObject * e) = 0;

	virtual void setPosition(Vector2 position) = 0;
	virtual Vector2 * getPosition() = 0;

	virtual void setColor(int color) = 0;
	virtual int getColor() = 0;
};
